/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.recipes.crafting.recipes;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.recipes.crafting.VerticalSlabCraftingRecipe;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BlockToVerticalSlabCraftingRecipe
extends VerticalSlabCraftingRecipe {
    public static final String ID = "block_to_vertical_slab_crafting_recipe";
    private static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("block_to_vertical_slab_crafting_recipe");

    public BlockToVerticalSlabCraftingRecipe() {
        super(1, 3);
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull ItemStack matchedItem) {
        Item slab = (Item)VerticalSlabUtils.MapsManager.blockMap.get((Object)matchedItem.m_41720_());
        ItemStack verticalSlab = VerticalSlabUtils.getVerticalSlabItem((BlockState)VerticalSlabUtils.MapsManager.slabStateMap.get((Object)slab), VerticalSlabUtils.isTranslucent(slab));
        verticalSlab.m_41764_(6);
        return verticalSlab;
    }

    public ResourceLocation m_6423_() {
        return RESOURCE_LOCATION;
    }

    public Serializer getSerializer() {
        return (Serializer)JustVerticalSlabsLoader.BLOCK_TO_VERTICAL_SLAB_CRAFTING_RECIPE_SERIALIZER.get();
    }

    @Override
    protected Integer getMatchIndex(CraftingContainer craftingContainer) {
        boolean correctPattern = true;
        Integer matchIndex = null;
        Integer containerWidth = craftingContainer.m_39347_();
        for (int h = 0; h < containerWidth && correctPattern; ++h) {
            for (int w = 0; w < craftingContainer.m_39346_() && correctPattern; ++w) {
                int index = w + h * containerWidth;
                ItemStack itemStack1 = craftingContainer.m_8020_(index);
                if (itemStack1.m_41619_()) continue;
                Item item = itemStack1.m_41720_();
                if (VerticalSlabUtils.MapsManager.blockMap.containsKey((Object)item)) {
                    ItemStack itemStack2 = craftingContainer.m_8020_(index + containerWidth);
                    ItemStack itemStack3 = craftingContainer.m_8020_(index + containerWidth * 2);
                    if (itemStack2.m_150930_(item) && itemStack3.m_150930_(item)) {
                        if (matchIndex == null) {
                            matchIndex = index;
                            continue;
                        }
                        matchIndex = null;
                        correctPattern = false;
                        continue;
                    }
                    if (matchIndex != null && (matchIndex == index - containerWidth || matchIndex == index - containerWidth * 2)) continue;
                    matchIndex = null;
                    correctPattern = false;
                    continue;
                }
                matchIndex = null;
                correctPattern = false;
            }
        }
        return matchIndex;
    }

    public static class Serializer
    extends VerticalSlabCraftingRecipe.Serializer<BlockToVerticalSlabCraftingRecipe> {
        public static final String ID = "block_to_vertical_slab_crafting_recipe_serializer";
        public static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("block_to_vertical_slab_crafting_recipe_serializer");

        public Serializer() {
            super(BlockToVerticalSlabCraftingRecipe::new);
        }
    }
}

